/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.block.drink;

import cloud.lemonslice.teastory.block.craft.IStoveBlock;
import cloud.lemonslice.teastory.blockentity.TeapotBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;
import xueluoanping.teastory.block.NormalHorizontalBlock;
import xueluoanping.teastory.client.SoundEventsRegistry;
import xueluoanping.teastory.registry.BlockEntityRegister;
import xueluoanping.teastory.registry.FluidRegistry;

public class TeapotBlock
extends NormalHorizontalBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0);

    public TeapotBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        double d0 = (double)pos.m_123341_() + 0.5;
        double d1 = (double)pos.m_123342_() + rand.m_188500_() * 6.0 / 16.0;
        double d2 = (double)pos.m_123343_() + 0.5;
        double d4 = rand.m_188500_() * 0.6 - 0.3;
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof TeapotBlockEntity && ((TeapotBlockEntity)tileentity).getFluid() == FluidRegistry.BOILING_WATER_STILL.get()) {
            worldIn.m_6493_((ParticleOptions)ParticleTypes.f_123796_, false, d0 + d4, d1 + 0.5, d2 + d4, 0.0, 0.1, 0.0);
        }
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof TeapotBlockEntity && IStoveBlock.isBurning((Level)worldIn, pos.m_7495_()) && ((TeapotBlockEntity)tileentity).getFluid() == Fluids.f_76193_) {
            ((TeapotBlockEntity)tileentity).setFluid((Fluid)FluidRegistry.BOILING_WATER_STILL.get());
        }
    }

    public void m_142072_(Level worldIn, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
        BlockEntity te;
        if (!worldIn.m_5776_() && (te = worldIn.m_7702_(pos)) instanceof TeapotBlockEntity) {
            worldIn.m_46961_(pos, false);
            Fluid fluid = ((TeapotBlockEntity)te).getFluid();
            if (fluid instanceof FlowingFluid) {
                worldIn.m_46597_(pos, ((FlowingFluid)fluid).m_5615_().m_76145_().m_76188_());
            }
            worldIn.m_5594_(null, pos, SoundEventsRegistry.CUP_BROKEN, SoundSource.BLOCKS, 0.5f, 0.9f);
        }
        super.m_142072_(worldIn, state, pos, entityIn, fallDistance);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player.m_21120_(handIn).m_41619_()) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.getSelf((BlockGetter)worldIn, pos));
            worldIn.m_46597_(pos, Blocks.f_50016_.m_49966_());
        } else {
            BlockEntity te = worldIn.m_7702_(pos);
            FluidUtil.getFluidHandler((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)player.m_21120_(handIn), (int)1)).ifPresent(item -> te.getCapability(ForgeCapabilities.FLUID_HANDLER, hit.m_82434_()).ifPresent(fluid -> FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)handIn, (IFluidHandler)fluid)));
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pos, BlockState pNewState, boolean isMoving) {
        super.m_6810_(pState, pLevel, pos, pNewState, isMoving);
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (pDirection == Direction.DOWN && pNeighborState.m_60795_()) {
            if (pLevel instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)pLevel;
                TeapotBlock.m_49840_((Level)serverLevel, (BlockPos)pPos, (ItemStack)this.getSelf((BlockGetter)serverLevel, pPos));
            }
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return this.getSelf(level, pos);
    }

    public ItemStack getSelf(BlockGetter worldIn, BlockPos pos) {
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (tileEntity instanceof TeapotBlockEntity) {
            FluidStack fluidStack = ((TeapotBlockEntity)tileEntity).getFluidTank().getFluidInTank(0);
            ItemStack itemStack = new ItemStack((ItemLike)this);
            if (fluidStack.isEmpty()) {
                return itemStack;
            }
            CompoundTag fluidTag = new CompoundTag();
            fluidStack.writeToNBT(fluidTag);
            itemStack.m_41784_().m_128365_("Fluid", (Tag)fluidTag);
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof TeapotBlockEntity) {
            FluidUtil.getFluidHandler((ItemStack)stack).ifPresent(f -> ((TeapotBlockEntity)tileentity).setFluidTank(f.getFluidInTank(0)));
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)BlockEntityRegister.TEAPOT_TYPE.get()).m_155264_(blockPos, blockState);
    }
}

